/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.config;

import io.neox.neonium.LittleTilesCompat;
import me.jellysquid.mods.sodium.common.config.EarlyModDetection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MixinConfig {
    private static Boolean littleTilesDetected = null;
    private static final Logger LOGGER = LogManager.getLogger((String)"LittleTilesCompat");

    public static boolean shouldDisableMixin(String mixinClassName) {
        return MixinConfig.shouldDisableForLittleTilesCompat(mixinClassName);
    }

    private static boolean isLittleTilesPresent() {
        if (littleTilesDetected != null) {
            return littleTilesDetected;
        }
        boolean isPresent = EarlyModDetection.isLittleTilesPresent();
        if (isPresent) {
            LOGGER.info("LittleTiles detected via early detection!");
            littleTilesDetected = true;
            return true;
        }
        try {
            isPresent = LittleTilesCompat.isLittleTilesLoaded();
            if (isPresent) {
                LOGGER.info("LittleTiles detected via runtime detection!");
            }
            littleTilesDetected = isPresent;
            return isPresent;
        }
        catch (Throwable t) {
            try {
                isPresent = Class.forName("com.creativemd.littletiles.LittleTiles", false, MixinConfig.class.getClassLoader()) != null;
                LOGGER.info("LittleTiles detected via direct class check!");
                littleTilesDetected = isPresent;
                return isPresent;
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("LittleTiles not found via direct class check");
                littleTilesDetected = false;
                return false;
            }
        }
    }

    private static boolean shouldDisableForLittleTilesCompat(String mixinClassName) {
        boolean shouldDisable;
        if (!MixinConfig.isLittleTilesPresent()) {
            return false;
        }
        boolean bl = shouldDisable = mixinClassName.equals("me.jellysquid.mods.sodium.mixin.features.chunk_rendering.MixinRenderGlobal") || mixinClassName.equals("me.jellysquid.mods.sodium.mixin.features.particle.cull.MixinParticleManager") || mixinClassName.equals("me.jellysquid.mods.sodium.mixin.features.chunk_rendering.MixinWorldRenderer") || mixinClassName.equals("me.jellysquid.mods.sodium.mixin.features.chunk_rendering.MixinChunkBuilder");
        if (shouldDisable) {
            LOGGER.info("Disabling mixin '" + mixinClassName + "' for LittleTiles compatibility");
        }
        return shouldDisable;
    }
}

